-- Send Provisional Offer Letter

SET @dataProviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICATION_REJECTION_POST_ASSESSMENT_VELOCITY_RCPNT');

 update sql_dtprovider set sqlQuery="SELECT 
    T6.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T2.`firstName` AS FIRST_NAME,
    T2.`middleName` AS MIDDLE_NAME,
    T2.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
    T2.`mobileCountryCode` AS MOBILE_CODE,
    T5.`loginId` AS LOGIN_ID,
    T17.`programNameToBePrint` AS program_Name,
    T16.`printName` AS batchName,
    T6.`rejection_remark` AS REJECTION_REMARK,
    CONVERT( FROM_BASE64(T5.passwordBase64) USING UTF8) AS PASSWORD,
    CONCAT(T9.addressText,
            ' ',
            T10.cityName,
            ', ',
            T11.countryName,
            ', ',
            T12.countryRegionName) AS ACADEMY_LOCATION_ADDRESS,
    DATE_FORMAT(T14.admissionOfferStartDate, '%d-%m-%Y') AS OFFER_LETTER_START_DATE,
    DATE_FORMAT(T14.admissionOfferEndDate, '%d-%m-%Y') AS OFFER_LETTER_END_DATE,
    'APPLICANT' AS USER_TYPE_KEY,
    ml.code AS LANGUAGE_KEY,
    T3.`salutationNameInOtherLanguage` AS TITLE_IN_OTHER_LANGUAGE,
    T17.`programNameToBePrintLanguageOne` AS PROGRAM_PRINT_NAME_LANGUAGE,
    ml.itemValue AS CORRESPONDENCE_LANGUAGE,
    T18.itemValue AS CURRENT_ACTIVITY,
    T19.groupName AS PROGRAM_GROUP_NAME,
    T20.itemValue AS INTAKE_YEAR
FROM
    `application` T1
        INNER JOIN
    `applicant_person` T2 ON T2.id = T1.applicantPersonId
        LEFT JOIN
    `current_activity` T18 ON T18.id = T2.current_activity_id
        LEFT JOIN
    `salutations` T3 ON T3.`id` = T2.`salutationId`
        LEFT JOIN
    `external_user_association` T4 ON T4.`applicationId` = T1.`id`
        LEFT JOIN
    `external_users` T5 ON T5.`id` = T4.`externalUserId`
        LEFT JOIN
    application_program T6 ON T6.applicationId = T1.id
        LEFT JOIN
    academy_location T7 ON T7.id = T6.academyLocationId
        LEFT JOIN
    prog_batch_seat_config T15 ON T15.id = T6.progBatchSeatConfigId
        LEFT JOIN
    batches T16 ON T16.id = T15.programBatchId
        LEFT JOIN
    programs T17 ON T17.id = T6.programId
        LEFT JOIN
    `program_group` T19 ON T19.id = T17.programGroupId
        LEFT JOIN
    academy_location_addresses T8 ON T8.academyLocationId = T7.id
        LEFT OUTER JOIN
    address T9 ON T9.id = T8.addressId
        && T9.addressTypeId = 10
        LEFT OUTER JOIN
    city T10 ON T10.id = T9.cityId
        LEFT OUTER JOIN
    country T11 ON T11.id = T10.countryId
        LEFT OUTER JOIN
    country_region T12 ON T12.id = T10.countryRegionId
        LEFT JOIN
    program_selection_process T13 ON T13.programBatchSeatConfigId = T6.progBatchSeatConfigId
        LEFT JOIN
    prog_slctn_process_admisn_conf T14 ON T14.programSelectionProcessId = T13.id
        LEFT JOIN
    multi_language ml ON ml.id = T2.correspondence_language
        LEFT JOIN
    intake_year T20 ON T20.id = T16.intakeYearId
WHERE
    T6.currentStatus = 'REJECTED' and
     T6.id IN 
     (
        namedParams
     )" ,
	jsonString='{
      "id": 1,
      "searchResultViewColumns": [
          {
              "id": 1,
              "value": "id",
              "resultKey": "ID",
              "displayCode": "",
              "displayOrder": 0
          },
          {
              "id": 2,
              "value": "salutationName",
              "resultKey": "SALUTATION_NAME",
              "displayCode": "",
              "displayOrder": 1
          },
          {
              "id": 3,
              "value": "firstName",
              "resultKey": "FIRST_NAME",
              "displayCode": "",
              "displayOrder": 2
          },
          {
              "id": 4,
              "value": "middleName",
              "resultKey": "MIDDLE_NAME",
              "displayCode": "",
              "displayOrder": 3
          },
          {
              "id": 5,
              "value": "lastName",
              "resultKey": "LAST_NAME",
              "displayCode": "",
              "displayOrder": 4
          },
          {
              "id": 6,
              "value": "emailId",
              "resultKey": "EMAIL_ID",
              "displayCode": "",
              "displayOrder": 5
          },
          {
              "id": 7,
              "value": "mobileNumber",
              "resultKey": "MOBILE_NO",
              "displayCode": "",
              "displayOrder": 6
          },
          {
              "id": 8,
              "value": "mobile Code",
              "resultKey": "MOBILE_CODE",
              "displayCode": "",
              "displayOrder": 7
          },
          {
              "id": 9,
              "value": "Login Id",
              "resultKey": "LOGIN_ID",
              "displayCode": "",
              "displayOrder": 8
          },
          {
              "id": 10,
              "value": "Password",
              "resultKey": "PASSWORD",
              "displayCode": "",
              "displayOrder": 9
          },
          {
              "id": 11,
              "value": "Academy Location Address",
              "resultKey": "ACADEMY_LOCATION_ADDRESS",
              "displayCode": "",
              "displayOrder": 10
          },
          {
              "id": 12,
              "value": "Offer Letter Start Date",
              "resultKey": "OFFER_LETTER_START_DATE",
              "displayCode": "",
              "displayOrder": 11
          },
          {
              "id": 13,
              "value": "Offer Letter End Date",
              "resultKey": "OFFER_LETTER_END_DATE",
              "displayCode": "",
              "displayOrder": 12
          },
          {
              "id": 14,
              "value": "Program",
              "resultKey": "program_Name",
              "displayCode": "",
              "displayOrder": 13
          },
          {
              "id": 15,
              "value": "Batch",
              "resultKey": "batchName",
              "displayCode": "",
              "displayOrder": 14
          },
          {
              "id": 16,
              "value": "Remarks",
              "resultKey": "REJECTION_REMARK",
              "displayCode": "",
              "displayOrder": 15
          },
         {
              "id": 17,
              "value": "Salutation / Title in other Language",
              "resultKey": "TITLE_IN_OTHER_LANGUAGE",
              "displayCode": "",
              "displayOrder": 16
          },
         {
              "id": 18,
              "value": "Program Name in Other Language",
              "resultKey": "PROGRAM_PRINT_NAME_LANGUAGE",
              "displayCode": "",
              "displayOrder": 17
          },
          {
              "id": 19,
              "value": "correspondence_language",
              "resultKey": "CORRESPONDENCE_LANGUAGE",
              "displayCode": "",
              "displayOrder": 18
          },
 		{
              "id": 20,
              "value": "itemValue",
              "resultKey": "CURRENT_ACTIVITY",
              "displayCode": "",
              "displayOrder": 19
          },
 		{
              "id": 21,
              "value": "groupName",
              "resultKey": "PROGRAM_GROUP_NAME",
              "displayCode": "",
              "displayOrder": 20
          },
          {
              "id": 22,
              "value": "itemValue",
              "resultKey": "INTAKE_YEAR",
              "displayCode": "",
              "displayOrder": 21
          }
      ]
  }' where dataProviderId=@dataProviderId;
  
  SET @dataProviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_APPLICANT_DTP');

 update sql_dtprovider set sqlQuery="SELECT 
    T6.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T2.`firstName` AS FIRST_NAME,
    T2.`middleName` AS MIDDLE_NAME,
    T2.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
    T2.`mobileCountryCode` AS MOBILE_CODE,
    T5.`loginId` AS LOGIN_ID,
    CONVERT( FROM_BASE64(T5.passwordBase64) USING UTF8) AS PASSWORD,
    CONCAT(T9.addressText,
            ' ',
            T10.cityName,
            ', ',
            T11.countryName,
            ', ',
            T12.countryRegionName) AS ACADEMY_LOCATION_ADDRESS,
    DATE_FORMAT(T14.admissionOfferStartDate, '%d-%m-%Y') AS OFFER_LETTER_START_DATE,
    DATE_FORMAT(T14.admissionOfferEndDate, '%d-%m-%Y') AS OFFER_LETTER_END_DATE,
    CONCAT(T9.phoneCountryCode, '-', T9.phoneNo) AS ACADEMY_LOCATION_PHONE_NO,
    T9.primaryeEmailId AS ACADEMY_LOCATION_EMAIL_ID,
    T9.websiteURL AS ACADEMY_LOCATION_URL,
    'APPLICANT' AS USER_TYPE_KEY,
    (CASE
        WHEN T15.offerType = 'FIRM' THEN 'Firm'
        WHEN T15.offerType = 'PROVISIONAL' THEN 'Provisional'
        ELSE ''
    END) AS FIRM_OR_PROVISIONAL,
    (CASE
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'APPLIED'
        THEN
            'Applied'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'NOT_APPLIED'
        THEN
            'Not Applied'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'SOLD'
        THEN
            'Sold'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'SUBMITTED'
        THEN
            'Submitted'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'APPROVED'
        THEN
            'Approved'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'REJECTED'
        THEN
            'Rejected'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'WITHDRAWN'
        THEN
            'Withdrawn'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'CLOSED'
        THEN
            'Closed'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'DIRECT_ADMISSION'
        THEN
            'Direct Admission'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'MID_TERM_ADMISSION'
        THEN
            'Mid term admission'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'DIRECT_SUBMISSION_TOKEN_GENERATED'
        THEN
            'Direct submission token generated'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'FORM_SALE_TOKEN_GENERATED'
        THEN
            'Form sale token generated'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'NOT_SUBMITTED'
        THEN
            'Not Submitted'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'ADMISSION_GRANTED'
        THEN
            'Admission granted'
        ELSE ''
    END) AS APPLICATION_STATUS,
    (CASE
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'OFFER_LETTER_ACCEPTED'
        THEN
            'Offer letter accepted'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'OFFER_LETTER_ISSUED'
        THEN
            'Offer letter issued'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'OFFER_LETTER_REJECTED'
        THEN
            'Offer letter rejected'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'OFFER_LETTER_DUE'
        THEN
            'Offer letter due'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'ACTIVE'
        THEN
            'Active'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'APPROVED'
        THEN
            'Approved'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'ADMITTED'
        THEN
            'Admitted'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'ADMITTED_ON_TRIAL'
        THEN
            'Admitted on trial'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'ADMITTED_ON_PROVISIONAL'
        THEN
            'Admitted on provisional'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'REJECTED'
        THEN
            'Rejected'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'WITHDRAWN'
        THEN
            'Withdrawn'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'WITHDRAW_AFTER_ACCEPTING_OFFER_LETTER'
        THEN
            'Withdrawn after accepting offer letter'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'CLOSED'
        THEN
            'Closed'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'PROVISIONAL_OFFER_ISSUED'
        THEN
            'Provisional offer issued'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'PROVISIONAL_OFFER_REJECTED'
        THEN
            'Provisional offer rejected'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'PROVISIONAL_OFFER_DUE'
        THEN
            'Provisional offer due'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'OFFER_EXPIRED'
        THEN
            'Offer Expired'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'PROVISIONAL_OFFER_EXPIRED'
        THEN
            'Provisional Offer Expired'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'ESCALATED'
        THEN
            'Escalated'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'ESCALATED_OFFER_REVIEWED'
        THEN
            'Escalated Offer Reviewed'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'WAITING_LIST'
        THEN
            'Waiting List'
        ELSE ''
    END) AS OFFER_STATUS,
    DATE_FORMAT(T1.`applicationCreatedOn`, '%d-%m-%Y') AS APPLICATION_DATE,
    (CASE
        WHEN
            T7.logoUrl IS NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T7.logoUrl IS NULL
                AND org.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T7.logoUrl)
    END) AS LOGO_URL,
    (CASE
        WHEN
            T7.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T7.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (CASE
        WHEN
            T7.footerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T7.footerUrl)
        ELSE NULL
    END) AS FOOTER_URL,
    T7.id AS ACADEMY_LOCATION_ID,
    T7.academyId AS ACADEMY_ID,
    ml.code AS LANGUAGE_KEY,
    ml.itemValue AS CORRESPONDENCE_LANGUAGE,
    T16.itemValue AS CURRENT_ACTIVITY,
    T19.groupName AS PROGRAM_GROUP_NAME,
    T18.programName AS PROGRAM,
    T20.batchName AS INTAKE,
    T21.itemValue AS INTAKE_YEAR
FROM
    `application` T1
        INNER JOIN
    `applicant_person` T2 ON T2.id = T1.applicantPersonId
        LEFT JOIN
    `current_activity` T16 ON T16.id = T2.current_activity_id
        LEFT JOIN
    `salutations` T3 ON T3.`id` = T2.`salutationId`
        LEFT JOIN
    `external_user_association` T4 ON T4.`applicationId` = T1.`id`
        LEFT JOIN
    `external_users` T5 ON T5.`id` = T4.`externalUserId`
        INNER JOIN
    `application_program` T6 ON T6.applicationId = T1.id
        LEFT JOIN
    `prog_batch_seat_config` T17 ON T17.id = T6.`progBatchSeatConfigId`
       INNER JOIN
    batches T20 ON T20.id = T17.programBatchId
        INNER JOIN
    `programs` T18 ON T18.id = T20.programId
        INNER JOIN
    `program_group` T19 ON T19.id = T18.programGroupId
        LEFT OUTER JOIN
    `academy_location` T7 ON T7.id = T6.academyLocationId
        LEFT OUTER JOIN
    `academy_location_addresses` T8 ON T8.academyLocationId = T7.id
        LEFT OUTER JOIN
    `address` T9 ON T9.id = T8.addressId
        && T9.addressTypeId = 10
        LEFT OUTER JOIN
    `city` T10 ON T10.id = T9.cityId
        LEFT OUTER JOIN
    `country` T11 ON T11.id = T10.countryId
        LEFT OUTER JOIN
    `country_region` T12 ON T12.id = T10.countryRegionId
        LEFT JOIN
    `program_selection_process` T13 ON T13.programBatchSeatConfigId = T6.progBatchSeatConfigId
        LEFT JOIN
    `prog_slctn_process_admisn_conf` T14 ON T14.programSelectionProcessId = T13.id
        LEFT JOIN
    `app_program_adm_details` T15 ON T15.applicationProgramId = T6.id
        AND T15.isLatest = TRUE
        LEFT OUTER JOIN
    `organizations` org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
        LEFT JOIN
    multi_language ml ON ml.id = T2.correspondence_language
    INNER JOIN
    intake_year T21 ON T21.id = T20.intakeYearId
WHERE
    T6.id IN (namedParams)
GROUP BY T2.id" ,
	jsonString='{
      "id": 1,
      "searchResultViewColumns": [
          {
              "id": 1,
              "value": "id",
              "resultKey": "ID",
              "displayCode": "",
              "displayOrder": 0
          },
          {
              "id": 2,
              "value": "salutationName",
              "resultKey": "SALUTATION_NAME",
              "displayCode": "",
              "displayOrder": 1
          },
          {
              "id": 3,
              "value": "firstName",
              "resultKey": "FIRST_NAME",
              "displayCode": "",
              "displayOrder": 2
          },
          {
              "id": 4,
              "value": "middleName",
              "resultKey": "MIDDLE_NAME",
              "displayCode": "",
              "displayOrder": 3
          },
          {
              "id": 5,
              "value": "lastName",
              "resultKey": "LAST_NAME",
              "displayCode": "",
              "displayOrder": 4
          },
          {
              "id": 6,
              "value": "emailId",
              "resultKey": "EMAIL_ID",
              "displayCode": "",
              "displayOrder": 5
          },
          {
              "id": 7,
              "value": "mobileNumber",
              "resultKey": "MOBILE_NO",
              "displayCode": "",
              "displayOrder": 6
          },
          {
              "id": 8,
              "value": "mobile Code",
              "resultKey": "MOBILE_CODE",
              "displayCode": "",
              "displayOrder": 7
          },
          {
              "id": 9,
              "value": "Login Id",
              "resultKey": "LOGIN_ID",
              "displayCode": "",
              "displayOrder": 8
          },
          {
              "id": 10,
              "value": "Password",
              "resultKey": "PASSWORD",
              "displayCode": "",
              "displayOrder": 9
          },
          {
              "id": 11,
              "value": "Academy Location Address",
              "resultKey": "ACADEMY_LOCATION_ADDRESS",
              "displayCode": "",
              "displayOrder": 10
          },
          {
              "id": 12,
              "value": "Offer Letter Start Date",
              "resultKey": "OFFER_LETTER_START_DATE",
              "displayCode": "",
              "displayOrder": 11
          },
          {
              "id": 13,
              "value": "Offer Letter End Date",
              "resultKey": "OFFER_LETTER_END_DATE",
              "displayCode": "",
              "displayOrder": 12
          },
          {
              "id": 14,
              "value": "applicationStatus",
              "resultKey": "APPLICATION_STATUS",
              "displayCode": "",
              "displayOrder": 13
          },
          {
              "id": 15,
              "value": "offerStatus",
              "resultKey": "OFFER_STATUS",
              "displayCode": "",
              "displayOrder": 14
          },
          {
              "id": 16,
              "value": "firmOrProvisional",
              "resultKey": "FIRM_OR_PROVISIONAL",
              "displayCode": "",
              "displayOrder": 15
          },
          {
              "id": 17,
              "value": "applicationDate",
              "resultKey": "APPLICATION_DATE",
              "displayCode": "",
              "displayOrder": 16
          },
          {
              "id": 18,
              "value": "logoURL",
              "resultKey": "LOGO_URL",
              "displayCode": "",
              "displayOrder": 17
          },
          {
              "id": 19,
              "value": "headerUrl",
              "resultKey": "HEADER_URL",
              "displayCode": "",
              "displayOrder": 18
          },
          {
              "id": 20,
              "value": "footerUrl",
              "resultKey": "FOOTER_URL",
              "displayCode": "",
              "displayOrder": 19
          },
          {
              "id": 21,
              "value": "academyLocationEmailId",
              "resultKey": "ACADEMY_LOCATION_EMAIL_ID",
              "displayCode": "",
              "displayOrder": 20
          },
          {
              "id": 22,
              "value": "academyLocationURL",
              "resultKey": "ACADEMY_LOCATION_URL",
              "displayCode": "",
              "displayOrder": 21
          },
          {
              "id": 23,
              "value": "academyLocationPhoneNo",
              "resultKey": "ACADEMY_LOCATION_PHONE_NO",
              "displayCode": "",
              "displayOrder": 22
          },
          {
              "id": 24,
              "value": "academyLocationId",
              "resultKey": "ACADEMY_LOCATION_ID",
              "displayCode": "",
              "displayOrder": 23
          },
          {
              "id": 25,
              "value": "academyId",
              "resultKey": "ACADEMY_ID",
              "displayCode": "",
              "displayOrder": 24
          },
          {
              "id": 26,
              "value": "correspondence_language",
              "resultKey": "CORRESPONDENCE_LANGUAGE",
              "displayCode": "",
              "displayOrder": 25
          },
 	{
              "id": 27,
              "value": "itemValue",
              "resultKey": "CURRENT_ACTIVITY",
              "displayCode": "",
              "displayOrder": 26
          },
 	{
              "id": 28,
              "value": "groupName",
              "resultKey": "PROGRAM_GROUP_NAME",
              "displayCode": "",
              "displayOrder": 27
          },
 {
			"id": 29,
			"value": "programName",
			"resultKey": "PROGRAM",
			"displayCode": "",
			"displayOrder": 28
		},
          {
			"id": 30,
			"value": "batchName",
			"resultKey": "INTAKE",
			"displayCode": "",
			"displayOrder": 29
		  },
           {
			"id": 31,
			"value": "itemValue",
			"resultKey": "INTAKE_YEAR",
			"displayCode": "",
			"displayOrder": 30
		  }
      ]
  }' where dataProviderId=@dataProviderId;
  
  
  SET @dataProviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPROVE_APPLICATION_RECIPIENTS');

 update sql_dtprovider set sqlQuery="SELECT 
    T4.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T2.`firstName` AS FIRST_NAME,
    T2.`middleName` AS MIDDLE_NAME,
    T2.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
    T1.`code` AS APPLICATION_CODE,
    ml.code AS LANGUAGE_KEY,
    (CASE
        WHEN
            T5.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T5.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (CASE
        WHEN
            T5.footerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T5.footerUrl)
        ELSE NULL
    END) AS FOOTER_URL,
    'APPLICANT' AS USER_TYPE_KEY,
    ml.itemValue AS CORRESPONDENCE_LANGUAGE,
    T8.itemValue AS CURRENT_ACTIVITY,
    T7.groupName AS PROGRAM_GROUP_NAME,
     T11.programName AS PROGRAM,
    T10.batchName AS INTAKE,
    T12.itemValue AS INTAKE_YEAR
FROM
    application T1
        LEFT OUTER JOIN
    applicant_person T2 ON T1.applicantPersonId = T2.id
        LEFT JOIN
    `current_activity` T8 ON T8.id = T2.current_activity_id
        LEFT OUTER JOIN
    salutations T3 ON T3.id = T2.salutationId
        LEFT OUTER JOIN
    application_program T4 ON T4.applicationId = T1.id
        LEFT OUTER JOIN
    academy_location T5 ON T5.id = T4.academyLocationId
        LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
        LEFT OUTER JOIN
    multi_language ml ON ml.id = T2.correspondence_language
     INNER JOIN
    prog_batch_seat_config T9 ON T9.id = T4.progBatchSeatConfigId
        INNER JOIN
    batches T10 ON T10.id = T9.programBatchId
        INNER JOIN
    programs T11 ON T11.id = T10.programId
        LEFT JOIN
    program_group T7 ON T7.id = T11.programGroupId
        INNER JOIN
    intake_year T12 ON T12.id = T10.intakeYearId
WHERE
    T4.id IN (namedParams)
GROUP BY T4.id" ,
	jsonString='{
      "id": 1,
      "searchResultViewColumns": [
          {
              "id": 1,
              "value": "id",
              "resultKey": "ID",
              "displayCode": "",
              "displayOrder": 0
          },
          {
              "id": 2,
              "value": "salutationName",
              "resultKey": "SALUTATION_NAME",
              "displayCode": "",
              "displayOrder": 1
          },
          {
              "id": 3,
              "value": "firstName",
              "resultKey": "FIRST_NAME",
              "displayCode": "",
              "displayOrder": 2
          },
          {
              "id": 4,
              "value": "middleName",
              "resultKey": "MIDDLE_NAME",
              "displayCode": "",
              "displayOrder": 3
          },
          {
              "id": 5,
              "value": "lastName",
              "resultKey": "LAST_NAME",
              "displayCode": "",
              "displayOrder": 4
          },
          {
              "id": 6,
              "value": "emailId",
              "resultKey": "EMAIL_ID",
              "displayCode": "",
              "displayOrder": 5
          },
          {
              "id": 7,
              "value": "mobileNumber",
              "resultKey": "MOBILE_NO",
              "displayCode": "",
              "displayOrder": 6
          },
          {
              "id": 8,
              "value": "code",
              "resultKey": "APPLICATION_CODE",
              "displayCode": "",
              "displayOrder": 7
          },
          {
              "id": 9,
              "value": "headerUrl",
              "resultKey": "HEADER_URL",
              "displayCode": "",
              "displayOrder": 8
          },
          {
              "id": 10,
              "value": "footerUrl",
              "resultKey": "FOOTER_URL",
              "displayCode": "",
              "displayOrder": 9
          },
          {
              "id": 11,
              "value": "correspondence_language",
              "resultKey": "CORRESPONDENCE_LANGUAGE",
              "displayCode": "",
              "displayOrder": 10
          },
 		{
              "id": 12,
              "value": "itemValue",
              "resultKey": "CURRENT_ACTIVITY",
              "displayCode": "",
              "displayOrder": 11
          },
 		{
              "id": 13,
              "value": "groupName",
              "resultKey": "PROGRAM_GROUP_NAME",
              "displayCode": "",
              "displayOrder": 12
          },
{
			"id": 14,
			"value": "programName",
			"resultKey": "PROGRAM",
			"displayCode": "",
			"displayOrder": 13
		},
          {
			"id": 15,
			"value": "batchName",
			"resultKey": "INTAKE",
			"displayCode": "",
			"displayOrder": 14
		  },
           {
			"id": 16,
			"value": "itemValue",
			"resultKey": "INTAKE_YEAR",
			"displayCode": "",
			"displayOrder": 15
		  }
      ]
  }' where dataProviderId=@dataProviderId;
  
  SET @dataProviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICANT_FORM_SUBMIT_RECIPIENTS');

 update sql_dtprovider set sqlQuery="SELECT 
    T1.id AS ID,
    T2.`firstName` AS FIRST_NAME,
    T2.`middleName` AS MIDDLE_NAME,
    T2.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
    T1.`code` AS APPLICATION_CODE,
    T2.`mobileCountryCode` AS MOBILE_CODE,
    T2.`alternateEmailId` AS ALTERNATE_EMAIL_ID,
    ml.`code` AS LANGUAGE_KEY,
    'APPLICANT' AS USER_TYPE_KEY,
    T9.programName AS PROGRAM,
    T8.batchName AS INTAKE,
    T11.itemValue AS INTAKE_YEAR,
    ml.itemValue AS CORRESPONDENCE_LANGUAGE,
    T12.itemValue AS CURRENT_ACTIVITY,
    T10.groupName AS PROGRAM_GROUP_NAME
FROM
    application T1
        LEFT OUTER JOIN
    applicant_person T2 ON T1.applicantPersonId = T2.id
        LEFT OUTER JOIN
    `current_activity` T12 ON T12.`id` = T2.`current_activity_id`
        LEFT OUTER JOIN
    external_user_association T5 ON T5.applicationId = T1.id
        LEFT OUTER JOIN
    external_users T4 ON T4.id = T5.externalUserId
        LEFT OUTER JOIN
    multi_language ml ON ml.id = T2.correspondence_language
        LEFT OUTER JOIN
    application_program T6 ON T6.applicationId = T1.id
       LEFT OUTER JOIN
    prog_batch_seat_config T7 ON T7.id = T6.progBatchSeatConfigId
        INNER JOIN
    batches T8 ON T8.id = T7.programBatchId
        INNER JOIN
    programs T9 ON T9.id = T8.programId
        LEFT OUTER JOIN
    program_group T10 ON T10.id = T9.programGroupId
        INNER JOIN
    intake_year T11 ON T11.id = T8.intakeYearId 
WHERE
    T1.id IN (namedParams)" ,
	jsonString='{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "middleName",
            "resultKey": "MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id":4,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "emailId",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "mobileNumber",
            "resultKey": "MOBILE_NO",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "code",
            "resultKey": "APPLICATION_CODE",
            "displayCode": "",
            "displayOrder": 6
        },
 {
			"id": 8,
			"value": "programName",
			"resultKey": "PROGRAM",
			"displayCode": "",
			"displayOrder": 7
		},
          {
			"id": 9,
			"value": "batchName",
			"resultKey": "INTAKE",
			"displayCode": "",
			"displayOrder": 8
		  },
           {
			"id": 10,
			"value": "itemValue",
			"resultKey": "INTAKE_YEAR",
			"displayCode": "",
			"displayOrder": 9
		  },
		  {
              "id": 11,
              "value": "correspondence_language",
              "resultKey": "CORRESPONDENCE_LANGUAGE",
              "displayCode": "",
              "displayOrder": 10
          },
		  {
               "id": 12,
               "value": "itemValue",
               "resultKey": "CURRENT_ACTIVITY",
               "displayCode": "",
               "displayOrder": 11
           },
           
            {
               "id": 13,
               "value": "groupName",
               "resultKey": "PROGRAM_GROUP_NAME",
               "displayCode": "",
               "displayOrder": 12
           }
    ]
}' where dataProviderId=@dataProviderId;


SET @dataProviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='ASSESSMENT_SELECTION_VELOCITY_RCPNT');

 update sql_dtprovider set sqlQuery="SELECT
    T6.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T2.`firstName` AS FIRST_NAME,
    T2.`middleName` AS MIDDLE_NAME,
    T2.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
    T2.`mobileCountryCode` AS MOBILE_CODE,
    T5.`loginId` AS LOGIN_ID,
    T15.`conditions` AS REJECTION_REMARK,
    CONVERT( FROM_BASE64(T5.passwordBase64) USING UTF8) AS PASSWORD,
    CONCAT(T9.addressText,
            ' ',
            T10.cityName,
            ', ',
            T11.countryName,
            ', ',
            T12.countryRegionName) AS ACADEMY_LOCATION_ADDRESS,
    DATE_FORMAT(T14.admissionOfferStartDate, '%d-%m-%Y') AS OFFER_LETTER_START_DATE,
    DATE_FORMAT(T14.admissionOfferEndDate, '%d-%m-%Y') AS OFFER_LETTER_END_DATE,
    'APPLICANT' AS USER_TYPE_KEY,
    T18.programName AS PROGRAM,
    T17.batchName AS INTAKE,
    T19.itemValue AS INTAKE_YEAR,
    ml.code AS LANGUAGE_KEY,
    ml.itemValue AS CORRESPONDENCE_LANGUAGE,
   T20.itemValue as CURRENT_ACTIVITY,
   T21.groupName AS PROGRAM_GROUP_NAME,
T22.seatName AS SEAT_TYPE
FROM
    `application` T1
        INNER JOIN
    `applicant_person` T2 ON T2.id = T1.applicantPersonId
         LEFT JOIN
     `current_activity` T20 ON T20.`id` = T2.`current_activity_id`
        LEFT JOIN
    `salutations` T3 ON T3.`id` = T2.`salutationId`
        LEFT JOIN
    `external_user_association` T4 ON T4.`applicationId` = T1.`id`
        LEFT JOIN
    `external_users` T5 ON T5.`id` = T4.`externalUserId`
        LEFT JOIN
    application_program T6 ON T6.applicationId = T1.id
        LEFT JOIN
    academy_location T7 ON T7.id = T6.academyLocationId
        LEFT JOIN
    application_condition T15 ON T15.applicationId = T1.id
        LEFT JOIN
    academy_location_addresses T8 ON T8.academyLocationId = T7.id
        LEFT OUTER JOIN
    address T9 ON T9.id = T8.addressId
        && T9.addressTypeId = 10
        LEFT OUTER JOIN
    city T10 ON T10.id = T9.cityId
        LEFT OUTER JOIN
    country T11 ON T11.id = T10.countryId
        LEFT OUTER JOIN
    country_region T12 ON T12.id = T10.countryRegionId
        LEFT JOIN
    program_selection_process T13 ON T13.programBatchSeatConfigId = T6.progBatchSeatConfigId
        LEFT JOIN
    prog_slctn_process_admisn_conf T14 ON T14.programSelectionProcessId = T13.id
        INNER JOIN
    prog_batch_seat_config T16 ON T16.id = T6.progBatchSeatConfigId
        INNER JOIN
    batches T17 ON T17.id = T16.programBatchId
        INNER JOIN
    programs T18 ON T18.id = T17.programId
   LEFT JOIN
       program_group T21 ON T21.id = T18.programGroupId
        INNER JOIN
    intake_year T19 ON T19.id = T17.intakeYearId
        LEFT JOIN
    multi_language ml ON ml.id = T2.correspondence_language
        LEFT JOIN
    seat_types T22 ON T22.id = T16.seatTypeId 
WHERE
   T6.id IN
   (
      namedParams
   )" ,
	jsonString='{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "salutationName",
            "resultKey": "SALUTATION_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "middleName",
            "resultKey": "MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "emailId",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "mobileNumber",
            "resultKey": "MOBILE_NO",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "mobile Code",
            "resultKey": "MOBILE_CODE",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "Login Id",
            "resultKey": "LOGIN_ID",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "Password",
            "resultKey": "PASSWORD",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "Academy Location Address",
            "resultKey": "ACADEMY_LOCATION_ADDRESS",
            "displayCode": "",
            "displayOrder": 10
        },
        {
            "id": 12,
            "value": "Offer Letter Start Date",
            "resultKey": "OFFER_LETTER_START_DATE",
            "displayCode": "",
            "displayOrder": 11
        },
        {
            "id": 13,
            "value": "Offer Letter End Date",
            "resultKey": "OFFER_LETTER_END_DATE",
            "displayCode": "",
            "displayOrder": 12
        },      
        {
            "id": 14,
            "value": "Remarks",
            "resultKey": "REJECTION_REMARK",
            "displayCode": "",
            "displayOrder": 13
        },
		 {
			"id": 15,
			"value": "programName",
			"resultKey": "PROGRAM",
			"displayCode": "",
			"displayOrder": 14
		},
          {
			"id": 16,
			"value": "batchName",
			"resultKey": "INTAKE",
			"displayCode": "",
			"displayOrder": 15
		  },
           {
			"id": 17,
			"value": "itemValue",
			"resultKey": "INTAKE_YEAR",
			"displayCode": "",
			"displayOrder": 16
		  },
		  {
              "id": 18,
              "value": "correspondence_language",
              "resultKey": "CORRESPONDENCE_LANGUAGE",
              "displayCode": "",
              "displayOrder": 17
          },
		  {
               "id": 19,
               "value": "itemValue",
               "resultKey": "CURRENT_ACTIVITY",
               "displayCode": "",
               "displayOrder": 18
           },
           
            {
               "id": 20,
               "value": "groupName",
               "resultKey": "PROGRAM_GROUP_NAME",
               "displayCode": "",
               "displayOrder": 19
           },
           {
               "id": 20,
               "value": "seatName",
               "resultKey": "SEAT_TYPE",
               "displayCode": "",
               "displayOrder": 19
           }
    ]
}' where dataProviderId=@dataProviderId;


SET @dataProviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='REJECT_APPLICATION_RECIPIENTS');

 update sql_dtprovider set sqlQuery="SELECT 
    T4.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T2.`firstName` AS FIRST_NAME,
    T2.`middleName` AS MIDDLE_NAME,
    T2.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
    T1.`code` AS APPLICATION_CODE,
    T5.displayName AS ACADEMY_NAME_LOCATION,
    CONCAT(T7.addressText,
            ' ',
            T8.cityName,
            ', ',
            T9.countryName,
            ', ',
            T10.countryRegionName) AS ACADEMY_LOCATION_ADDRESS,
    CONCAT(T7.phoneCountryCode, '-', T7.phoneNo) AS ACADEMY_LOCATION_PHONE_NO,
    T7.primaryeEmailId AS ACADEMY_LOCATION_EMAIL_ID,
    T11.programName AS PROGRAM_NAME,
    T13.batchName AS BATCH_NAME,
    T14.printName AS APPLICATION_OWNER_NAME,
    T16.emailId AS OWNER_EMAIL_ID,
    ml.`code` AS LANGUAGE_KEY,
    CONCAT(T16.mobileCountryCode,
            ' ',
            T16.mobileNumber) AS OWNER_MOBILE_NO,
    (CASE
        WHEN
            T5.logoUrl IS NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T5.logoUrl IS NULL
                AND org.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T5.logoUrl)
    END) AS LOGO_URL,
    T3.`salutationNameInOtherLanguage` AS TITLE_IN_OTHER_LANGUAGE,
    T11.`programNameToBePrintLanguageOne` AS PROGRAM_PRINT_NAME_LANGUAGE,
    ml.itemValue AS CORRESPONDENCE_LANGUAGE,
    T19.itemValue AS CURRENT_ACTIVITY,
    T18.groupName AS PROGRAM_GROUP_NAME,
    T20.itemValue AS INTAKE_YEAR
FROM
    application T1
        LEFT OUTER JOIN
    applicant_person T2 ON T1.applicantPersonId = T2.id
        LEFT JOIN
    current_activity T19 ON T19.id = T2.current_activity_id
        INNER JOIN
    salutations T3 ON T3.id = T2.salutationId
        LEFT JOIN
    application_program T4 ON T4.applicationId = T1.id
        LEFT OUTER JOIN
    academy_location T5 ON T5.id = T4.academyLocationId
        LEFT OUTER JOIN
    academy_location_addresses T6 ON T6.academyLocationId = T5.id
        LEFT OUTER JOIN
    address T7 ON T7.id = T6.addressId
        && T7.addressTypeId = 10
        LEFT OUTER JOIN
    city T8 ON T8.id = T7.cityId
        LEFT OUTER JOIN
    country T9 ON T9.id = T8.countryId
        LEFT OUTER JOIN
    country_region T10 ON T10.id = T8.countryRegionId
        LEFT OUTER JOIN
    programs T11 ON T11.id = T4.programId
        LEFT JOIN
    program_group T18 ON T18.id = T11.programGroupId
        LEFT JOIN
    prog_batch_seat_config T22 ON T4.progBatchSeatConfigId = T22.id
        LEFT JOIN
    batches T13 ON T13.id = T22.programBatchId
        LEFT JOIN
    users T14 ON T14.id = T1.applicationOwner
        LEFT JOIN
    staffs T15 ON T15.userId = T14.id
        LEFT JOIN
    persons T16 ON T16.id = T15.personId
        LEFT JOIN
    multi_language ml ON ml.id = T2.correspondence_language
        LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
        INNER JOIN
    intake_year T20 ON T20.id = T13.intakeYearId 
WHERE
    T4.id IN (namedParams)
GROUP BY T4.id" ,
	jsonString='{
      "id": 1,
      "searchResultViewColumns": [
          {
              "id": 1,
              "value": "id",
              "resultKey": "ID",
              "displayCode": "",
              "displayOrder": 0
          },
          {
              "id": 2,
              "value": "salutationName",
              "resultKey": "SALUTATION_NAME",
              "displayCode": "",
              "displayOrder": 1
          },
          {
              "id": 3,
              "value": "firstName",
              "resultKey": "FIRST_NAME",
              "displayCode": "",
              "displayOrder": 2
          },
          {
              "id": 4,
              "value": "middleName",
              "resultKey": "MIDDLE_NAME",
              "displayCode": "",
              "displayOrder": 3
          },
          {
              "id": 5,
              "value": "lastName",
              "resultKey": "LAST_NAME",
              "displayCode": "",
              "displayOrder": 4
          },
          {
              "id": 6,
              "value": "emailId",
              "resultKey": "EMAIL_ID",
              "displayCode": "",
              "displayOrder": 5
          },
          {
              "id": 7,
              "value": "mobileNumber",
              "resultKey": "MOBILE_NO",
              "displayCode": "",
              "displayOrder": 6
          },
          {
              "id": 8,
              "value": "code",
              "resultKey": "APPLICATION_CODE",
              "displayCode": "",
              "displayOrder": 7
          },
          {
              "id": 9,
              "value": "logoUrl",
              "resultKey": "LOGO_URL",
              "displayCode": "",
              "displayOrder": 8
          },
          {
              "id": 10,
              "value": "displayName",
              "resultKey": "ACADEMY_NAME_LOCATION",
              "displayCode": "",
              "displayOrder": 9
          },
          {
              "id": 11,
              "value": "Academy Location Address",
              "resultKey": "ACADEMY_LOCATION_ADDRESS",
              "displayCode": "",
              "displayOrder": 10
          },
          {
              "id": 12,
              "value": "Academy Location Phone No.",
              "resultKey": "ACADEMY_LOCATION_PHONE_NO",
              "displayCode": "",
              "displayOrder": 11
          },
          {
              "id": 13,
              "value": "Academy Location Email Id",
              "resultKey": "ACADEMY_LOCATION_EMAIL_ID",
              "displayCode": "",
              "displayOrder": 12
          },
          {
              "id": 14,
              "value": "Program Name",
              "resultKey": "PROGRAM_NAME",
              "displayCode": "",
              "displayOrder": 13
          },
          {
              "id": 15,
              "value": "Batch Name",
              "resultKey": "BATCH_NAME",
              "displayCode": "",
              "displayOrder": 14
          },
          {
              "id": 16,
              "value": "Application Owner Name",
              "resultKey": "APPLICATION_OWNER_NAME",
              "displayCode": "",
              "displayOrder": 15
          },
          {
              "id": 17,
              "value": "Owner EmailId",
              "resultKey": "OWNER_EMAIL_ID",
              "displayCode": "",
              "displayOrder": 16
          },
          {
              "id": 18,
              "value": "Owner Mobile No",
              "resultKey": "OWNER_MOBILE_NO",
              "displayCode": "",
              "displayOrder": 17
          },
          {
              "id": 19,
              "value": "Reason for Rejection",
              "resultKey": "REASON_FOR_REJECTION",
              "displayCode": "",
              "displayOrder": 18
          },
          {
              "id": 20,
              "value": "Rejection Remarks",
              "resultKey": "REJECTION_REMARKS",
              "displayCode": "",
              "displayOrder": 19
          },{
              "id": 21,
              "value": "Salutation / Title in other Language",
              "resultKey": "TITLE_IN_OTHER_LANGUAGE",
              "displayCode": "",
              "displayOrder": 20
          },{
              "id": 22,
              "value": "Program Name in Other Language",
              "resultKey": "PROGRAM_PRINT_NAME_LANGUAGE",
              "displayCode": "",
              "displayOrder": 21
          },
 	{
              "id": 21,
              "value": "correspondence_language",
              "resultKey": "CORRESPONDENCE_LANGUAGE",
              "displayCode": "",
              "displayOrder": 20
          },
 		{
              "id": 22,
              "value": "itemValue",
              "resultKey": "CURRENT_ACTIVITY",
              "displayCode": "",
              "displayOrder": 21
          },
 	{
              "id": 23,
              "value": "groupName",
              "resultKey": "PROGRAM_GROUP_NAME",
              "displayCode": "",
              "displayOrder": 22
          },
 {
			"id": 24,
			"value": "itemValue",
			"resultKey": "INTAKE_YEAR",
			"displayCode": "",
			"displayOrder": 23
		  }
      ]
  }' where dataProviderId=@dataProviderId;
  
  
  SET @dataProviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_APPLICANT_DTP');

 update sql_dtprovider set sqlQuery="SELECT 
    T6.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T2.`firstName` AS FIRST_NAME,
    T2.`middleName` AS MIDDLE_NAME,
    T2.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
    T2.`mobileCountryCode` AS MOBILE_CODE,
    T5.`loginId` AS LOGIN_ID,
    CONVERT( FROM_BASE64(T5.passwordBase64) USING UTF8) AS PASSWORD,
    CONCAT(T9.addressText,
            ' ',
            T10.cityName,
            ', ',
            T11.countryName,
            ', ',
            T12.countryRegionName) AS ACADEMY_LOCATION_ADDRESS,
    DATE_FORMAT(T14.admissionOfferStartDate, '%d-%m-%Y') AS OFFER_LETTER_START_DATE,
    DATE_FORMAT(T14.admissionOfferEndDate, '%d-%m-%Y') AS OFFER_LETTER_END_DATE,
    CONCAT(T9.phoneCountryCode, '-', T9.phoneNo) AS ACADEMY_LOCATION_PHONE_NO,
    T9.primaryeEmailId AS ACADEMY_LOCATION_EMAIL_ID,
    T9.websiteURL AS ACADEMY_LOCATION_URL,
    'APPLICANT' AS USER_TYPE_KEY,
    (CASE
        WHEN T15.offerType = 'FIRM' THEN 'Firm'
        WHEN T15.offerType = 'PROVISIONAL' THEN 'Provisional'
        ELSE ''
    END) AS FIRM_OR_PROVISIONAL,
    (CASE
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'APPLIED'
        THEN
            'Applied'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'NOT_APPLIED'
        THEN
            'Not Applied'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'SOLD'
        THEN
            'Sold'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'SUBMITTED'
        THEN
            'Submitted'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'APPROVED'
        THEN
            'Approved'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'REJECTED'
        THEN
            'Rejected'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'WITHDRAWN'
        THEN
            'Withdrawn'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'CLOSED'
        THEN
            'Closed'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'DIRECT_ADMISSION'
        THEN
            'Direct Admission'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'MID_TERM_ADMISSION'
        THEN
            'Mid term admission'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'DIRECT_SUBMISSION_TOKEN_GENERATED'
        THEN
            'Direct submission token generated'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'FORM_SALE_TOKEN_GENERATED'
        THEN
            'Form sale token generated'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'NOT_SUBMITTED'
        THEN
            'Not Submitted'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'ADMISSION_GRANTED'
        THEN
            'Admission granted'
        ELSE ''
    END) AS APPLICATION_STATUS,
    (CASE
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'OFFER_LETTER_ACCEPTED'
        THEN
            'Offer letter accepted'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'OFFER_LETTER_ISSUED'
        THEN
            'Offer letter issued'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'OFFER_LETTER_REJECTED'
        THEN
            'Offer letter rejected'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'OFFER_LETTER_DUE'
        THEN
            'Offer letter due'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'ACTIVE'
        THEN
            'Active'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'APPROVED'
        THEN
            'Approved'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'ADMITTED'
        THEN
            'Admitted'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'ADMITTED_ON_TRIAL'
        THEN
            'Admitted on trial'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'ADMITTED_ON_PROVISIONAL'
        THEN
            'Admitted on provisional'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'REJECTED'
        THEN
            'Rejected'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'WITHDRAWN'
        THEN
            'Withdrawn'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'WITHDRAW_AFTER_ACCEPTING_OFFER_LETTER'
        THEN
            'Withdrawn after accepting offer letter'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'CLOSED'
        THEN
            'Closed'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'PROVISIONAL_OFFER_ISSUED'
        THEN
            'Provisional offer issued'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'PROVISIONAL_OFFER_REJECTED'
        THEN
            'Provisional offer rejected'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'PROVISIONAL_OFFER_DUE'
        THEN
            'Provisional offer due'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'OFFER_EXPIRED'
        THEN
            'Offer Expired'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'PROVISIONAL_OFFER_EXPIRED'
        THEN
            'Provisional Offer Expired'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'ESCALATED'
        THEN
            'Escalated'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'ESCALATED_OFFER_REVIEWED'
        THEN
            'Escalated Offer Reviewed'
        WHEN
            T6.currentStatus IS NOT NULL
                AND T6.currentStatus = 'WAITING_LIST'
        THEN
            'Waiting List'
        ELSE ''
    END) AS OFFER_STATUS,
    DATE_FORMAT(T1.`applicationCreatedOn`, '%d-%m-%Y') AS APPLICATION_DATE,
    (CASE
        WHEN
            T7.logoUrl IS NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T7.logoUrl IS NULL
                AND org.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T7.logoUrl)
    END) AS LOGO_URL,
    (CASE
        WHEN
            T7.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T7.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (CASE
        WHEN
            T7.footerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T7.footerUrl)
        ELSE NULL
    END) AS FOOTER_URL,
    T7.id AS ACADEMY_LOCATION_ID,
    T7.academyId AS ACADEMY_ID,
    ml.code AS LANGUAGE_KEY,
    ml.itemValue AS CORRESPONDENCE_LANGUAGE,
    T16.itemValue AS CURRENT_ACTIVITY,
    T19.groupName AS PROGRAM_GROUP_NAME,
    T18.programName AS PROGRAM,
    T20.batchName AS INTAKE,
    T21.itemValue AS INTAKE_YEAR,
    T22.seatName AS SEAT_TYPE
FROM
    `application` T1
        INNER JOIN
    `applicant_person` T2 ON T2.id = T1.applicantPersonId
        LEFT JOIN
    `current_activity` T16 ON T16.id = T2.current_activity_id
        LEFT JOIN
    `salutations` T3 ON T3.`id` = T2.`salutationId`
        LEFT JOIN
    `external_user_association` T4 ON T4.`applicationId` = T1.`id`
        LEFT JOIN
    `external_users` T5 ON T5.`id` = T4.`externalUserId`
        INNER JOIN
    `application_program` T6 ON T6.applicationId = T1.id
        LEFT JOIN
    `prog_batch_seat_config` T17 ON T17.id = T6.`progBatchSeatConfigId`
       INNER JOIN
    batches T20 ON T20.id = T17.programBatchId
        INNER JOIN
    `programs` T18 ON T18.id = T20.programId
        INNER JOIN
    `program_group` T19 ON T19.id = T18.programGroupId
        LEFT OUTER JOIN
    `academy_location` T7 ON T7.id = T6.academyLocationId
        LEFT OUTER JOIN
    `academy_location_addresses` T8 ON T8.academyLocationId = T7.id
        LEFT OUTER JOIN
    `address` T9 ON T9.id = T8.addressId
        && T9.addressTypeId = 10
        LEFT OUTER JOIN
    `city` T10 ON T10.id = T9.cityId
        LEFT OUTER JOIN
    `country` T11 ON T11.id = T10.countryId
        LEFT OUTER JOIN
    `country_region` T12 ON T12.id = T10.countryRegionId
        LEFT JOIN
    `program_selection_process` T13 ON T13.programBatchSeatConfigId = T6.progBatchSeatConfigId
        LEFT JOIN
    `prog_slctn_process_admisn_conf` T14 ON T14.programSelectionProcessId = T13.id
        LEFT JOIN
    `app_program_adm_details` T15 ON T15.applicationProgramId = T6.id
        AND T15.isLatest = TRUE
        LEFT OUTER JOIN
    `organizations` org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
        LEFT JOIN
    multi_language ml ON ml.id = T2.correspondence_language
    INNER JOIN
    intake_year T21 ON T21.id = T20.intakeYearId
	LEFT JOIN
    seat_types T22 ON T22.id = T17.seatTypeId 
WHERE
    T6.id IN (namedParams)
GROUP BY T2.id" ,
	jsonString='{
      "id": 1,
      "searchResultViewColumns": [
          {
              "id": 1,
              "value": "id",
              "resultKey": "ID",
              "displayCode": "",
              "displayOrder": 0
          },
          {
              "id": 2,
              "value": "salutationName",
              "resultKey": "SALUTATION_NAME",
              "displayCode": "",
              "displayOrder": 1
          },
          {
              "id": 3,
              "value": "firstName",
              "resultKey": "FIRST_NAME",
              "displayCode": "",
              "displayOrder": 2
          },
          {
              "id": 4,
              "value": "middleName",
              "resultKey": "MIDDLE_NAME",
              "displayCode": "",
              "displayOrder": 3
          },
          {
              "id": 5,
              "value": "lastName",
              "resultKey": "LAST_NAME",
              "displayCode": "",
              "displayOrder": 4
          },
          {
              "id": 6,
              "value": "emailId",
              "resultKey": "EMAIL_ID",
              "displayCode": "",
              "displayOrder": 5
          },
          {
              "id": 7,
              "value": "mobileNumber",
              "resultKey": "MOBILE_NO",
              "displayCode": "",
              "displayOrder": 6
          },
          {
              "id": 8,
              "value": "mobile Code",
              "resultKey": "MOBILE_CODE",
              "displayCode": "",
              "displayOrder": 7
          },
          {
              "id": 9,
              "value": "Login Id",
              "resultKey": "LOGIN_ID",
              "displayCode": "",
              "displayOrder": 8
          },
          {
              "id": 10,
              "value": "Password",
              "resultKey": "PASSWORD",
              "displayCode": "",
              "displayOrder": 9
          },
          {
              "id": 11,
              "value": "Academy Location Address",
              "resultKey": "ACADEMY_LOCATION_ADDRESS",
              "displayCode": "",
              "displayOrder": 10
          },
          {
              "id": 12,
              "value": "Offer Letter Start Date",
              "resultKey": "OFFER_LETTER_START_DATE",
              "displayCode": "",
              "displayOrder": 11
          },
          {
              "id": 13,
              "value": "Offer Letter End Date",
              "resultKey": "OFFER_LETTER_END_DATE",
              "displayCode": "",
              "displayOrder": 12
          },
          {
              "id": 14,
              "value": "applicationStatus",
              "resultKey": "APPLICATION_STATUS",
              "displayCode": "",
              "displayOrder": 13
          },
          {
              "id": 15,
              "value": "offerStatus",
              "resultKey": "OFFER_STATUS",
              "displayCode": "",
              "displayOrder": 14
          },
          {
              "id": 16,
              "value": "firmOrProvisional",
              "resultKey": "FIRM_OR_PROVISIONAL",
              "displayCode": "",
              "displayOrder": 15
          },
          {
              "id": 17,
              "value": "applicationDate",
              "resultKey": "APPLICATION_DATE",
              "displayCode": "",
              "displayOrder": 16
          },
          {
              "id": 18,
              "value": "logoURL",
              "resultKey": "LOGO_URL",
              "displayCode": "",
              "displayOrder": 17
          },
          {
              "id": 19,
              "value": "headerUrl",
              "resultKey": "HEADER_URL",
              "displayCode": "",
              "displayOrder": 18
          },
          {
              "id": 20,
              "value": "footerUrl",
              "resultKey": "FOOTER_URL",
              "displayCode": "",
              "displayOrder": 19
          },
          {
              "id": 21,
              "value": "academyLocationEmailId",
              "resultKey": "ACADEMY_LOCATION_EMAIL_ID",
              "displayCode": "",
              "displayOrder": 20
          },
          {
              "id": 22,
              "value": "academyLocationURL",
              "resultKey": "ACADEMY_LOCATION_URL",
              "displayCode": "",
              "displayOrder": 21
          },
          {
              "id": 23,
              "value": "academyLocationPhoneNo",
              "resultKey": "ACADEMY_LOCATION_PHONE_NO",
              "displayCode": "",
              "displayOrder": 22
          },
          {
              "id": 24,
              "value": "academyLocationId",
              "resultKey": "ACADEMY_LOCATION_ID",
              "displayCode": "",
              "displayOrder": 23
          },
          {
              "id": 25,
              "value": "academyId",
              "resultKey": "ACADEMY_ID",
              "displayCode": "",
              "displayOrder": 24
          },
          {
              "id": 26,
              "value": "correspondence_language",
              "resultKey": "CORRESPONDENCE_LANGUAGE",
              "displayCode": "",
              "displayOrder": 25
          },
 	{
              "id": 27,
              "value": "itemValue",
              "resultKey": "CURRENT_ACTIVITY",
              "displayCode": "",
              "displayOrder": 26
          },
 	{
              "id": 28,
              "value": "groupName",
              "resultKey": "PROGRAM_GROUP_NAME",
              "displayCode": "",
              "displayOrder": 27
          },
 {
			"id": 29,
			"value": "programName",
			"resultKey": "PROGRAM",
			"displayCode": "",
			"displayOrder": 28
		},
          {
			"id": 30,
			"value": "batchName",
			"resultKey": "INTAKE",
			"displayCode": "",
			"displayOrder": 29
		  },
           {
			"id": 31,
			"value": "itemValue",
			"resultKey": "INTAKE_YEAR",
			"displayCode": "",
			"displayOrder": 29
		  },
           {
			"id": 32,
			"value": "seatName",
			"resultKey": "SEAT_TYPE",
			"displayCode": "",
			"displayOrder": 30
		  }
      ]
  }' where dataProviderId=@dataProviderId;
  
  

